# Help

## How to use Personal Scroller

Personal Scroller uses Controllers to define what traits to gather from short form videos it sees (for example, `top-comment` or `likes`) 

It then uses Operators to operate the SFV platform and gather the traits it sees

The output is saved by default to your computer under `/Documents/Personal Scroller/Captures`

## How to install plugins

You should download plugins.zip from Google Drive and unzip it, then move the individual files (not the plugins folder) to `/Documents/Personal Scroller/Plugins` (on some versions this may be ``/Documents/sfvc/Plugins``)

---

# About Personal Scroller

Personal Scroller is a research software for browsing and archiving shortform videos (SFV) from commercial platforms (YouTube Short, TikTok, Instagram Reels).

## Description

The Personal Scroller automatically browses a given SFV platform using Puppeteer, and saves all information about the videos watched. Browsing the platform is achieved by different __operator plugins__ and the specification of the information to be saved is achieved by different __controller plugins__.

This software is licensed under the [GPLv3](./LICENSE), and thus should only be used for research purposes, and not for commercial purposes.

## Usage

You can download the Personal Scroller from the releases page.

## Further resources

Find more info on [the wiki](https://gitlab.com/periode/sfv-collector/-/wikis/home).

## Development

### Requirements

The Personal Scroller runs as an electron app.

- `node@^14.17`
- `npm@^16.14`
- `typescript@^5.5`
- `puppeteer@24.16.0`
- `electron@39.2.7`

If you want to package it as an app, you will also need electron-forge packages.

### Installation

```sh
git clone https://periode.gitlab.com/personal-scroller
cd personal-scroller
echo "VITE_SERVER_HOST=http://localhost:3000" > ./client/.env
```

### Run

Run the provided bash script (`./start.sh`) or the provided Makefile (`make run`). Both of these methods take care of installing dependencies, building the client frontend, and running the backend.

Once the server is running, open the server address shown in the terminal in a new browser window.

## Credits

Developer at the [Hochschule für Gestaltung Karlsruhe](https://hfg-karlsruhe.de), by Marc Hudnut and Pierre Depaz.
