"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppSettingsSchemaFactory = exports.PluginManifestSchema = exports.AppProcessStatusSchema = exports.EventSchema = exports.GatheredTraitSchema = exports.EventManifestSchema = exports.RequestedTrait = exports.CaptureSchema = exports.JobChangeRequestSchema = exports.JobRequestSchema = exports.PatchCaptureActionSchema = exports.StringArraySchema = exports.PathSchema = exports.StringDict = void 0;
const z = __importStar(require("zod/v4"));
// Utility type for Dictionary<string, string>
exports.StringDict = z.record(z.string(), z.string());
exports.PathSchema = z.string();
exports.StringArraySchema = z.array(z.string());
exports.PatchCaptureActionSchema = z.object({
    name: z.string(),
});
exports.JobRequestSchema = z.object({
    operator: z.string(),
    controllers: z.array(z.string()),
    events: z.number().int().min(0),
    job_name: z.string().default("")
});
exports.JobChangeRequestSchema = z.object({
    events: z.number().int().min(0),
    job_name: z.string().default(""),
    job_running: z.boolean().default(true)
});
exports.CaptureSchema = z.object({
    capture_id: z.string(),
    error: z.string(),
    started_at: z.coerce.date(),
    additional_data: exports.StringDict,
    capture_name: z.string().default("")
});
exports.RequestedTrait = z.object({
    trait: z.string(),
    requested_by: z.array(z.string())
});
exports.EventManifestSchema = z.object({
    video_id: z.string(),
    gathered_at: z.coerce.date(),
    gathered_by: z.string(),
    requested_traits: z.array(exports.RequestedTrait),
    event_id: z.string()
});
exports.GatheredTraitSchema = z.object({
    raw: z.string(),
    processed: z.string(),
});
exports.EventSchema = z.object({
    manifest: exports.EventManifestSchema,
    gathered_traits: z.map(z.string(), exports.GatheredTraitSchema)
});
exports.AppProcessStatusSchema = z.object({
    events_gathered: z.number(),
    currently_gathering: z.string(),
    current_event: z.string(),
    current_capture: z.string(),
});
exports.PluginManifestSchema = z.object({
    name: z.string(),
    author: z.string(),
    description: z.string(),
    version: z.string(),
    type: z.enum(["controller", "operator", "collector", "extension"]),
    traits: z.array(z.string()).optional().or(z.literal(''))
});
/**
 * Initializes appropriate defaults for AppSettings.
 */
const AppSettingsSchemaFactory = (plugins_default, captures_default) => z.object({
    captures_directory: exports.PathSchema.default(captures_default),
    plugins_directory: exports.PathSchema.default(plugins_default),
    event_format: z.string().default("event_{id}_{time}_{date}"),
    capture_format: z.string().default("capture_{id}_{time}_{date}")
});
exports.AppSettingsSchemaFactory = AppSettingsSchemaFactory;
//# sourceMappingURL=schemas.js.map