"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = setupExpressAPI;
const express_1 = __importDefault(require("express"));
const path_1 = __importDefault(require("path"));
const cors_1 = __importDefault(require("cors"));
const body_parser_1 = __importDefault(require("body-parser"));
/**
 * Sets up the Express API to use the given Express Router
 */
function setupExpressAPI(router, logger, resources_path, dev_mode) {
    const app = (0, express_1.default)();
    app.use(body_parser_1.default.json());
    if (dev_mode) {
        const corsOptions = {
            origin: ["http://localhost:5173"]
        };
        app.use((0, cors_1.default)(corsOptions));
    }
    app.use(router);
    app.use(express_1.default.static(path_1.default.join(resources_path, 'dist', 'frontend')));
    // Start the server
    const PORT = process.env.PORT || 3000;
    app.listen(PORT, () => {
        logger.info(`Server started at http://localhost:${PORT}/`);
    });
}
//# sourceMappingURL=api_service.js.map