"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/** @inheritdoc */
class ConfigurationService {
    constructor() {
        this.configMaps = {
            string: new Map(),
            number: new Map(),
            boolean: new Map(),
        };
        this.configValidators = {
            string: new Map(),
            number: new Map(),
            boolean: undefined,
        };
    }
    /** @inheritdoc */
    listConfigurations(domain) {
        const configurations = [];
        const boolean_map = this.configMaps.boolean.get(domain);
        const string_map = this.configMaps.string.get(domain);
        const number_map = this.configMaps.number.get(domain);
        if (boolean_map) {
            for (const [key, value] of boolean_map.entries()) {
                configurations.push(`[${key}, ${value}]`);
            }
        }
        if (string_map) {
            for (const [key, value] of string_map.entries()) {
                configurations.push(`[${key}, ${value}]`);
            }
        }
        if (number_map) {
            for (const [key, value] of number_map.entries()) {
                configurations.push(`[${key}, ${value}]`);
            }
        }
        return configurations;
    }
    /** @inheritdoc */
    addConfig(domain, name, value, validator) {
        const type = typeof value;
        const configMap = this.configMaps[type];
        if (validator) {
            const validatorMap = this.configValidators[type];
            if (type == 'boolean')
                throw "Validators are not allowed on booleans";
            if (!validatorMap.has(domain)) {
                validatorMap.set(domain, new Map());
            }
            validatorMap.get(domain).set(name, validator);
        }
        const map = configMap.get(domain);
        if (!map) {
            configMap.set(domain, new Map([[name, [value, undefined]]])); //have you ever seen this many square brackets!!!
            return;
        }
        map.set(name, [value, undefined]);
    }
    /** @inheritdoc */
    setConfig(domain, name, value) {
        for (const type of ["string", "number", "boolean"]) {
            if (type == typeof value) {
                const map = this.configMaps[type].get(domain);
                if (map) {
                    const tuple = map.get(name);
                    console.log(map);
                    if (tuple) {
                        console.log(tuple);
                        if (type != 'boolean') {
                            const validators = this.configValidators[type].get(domain);
                            const validator = validators?.get(name);
                            if (validator) {
                                console.log(validator);
                                if (!validator.validate(value)) {
                                    return false;
                                }
                            }
                        }
                        map.set(name, [tuple[0], value]);
                        return true;
                    }
                }
            }
        }
        return false;
    }
    /** @inheritdoc */
    getConfig(domain, name, default_value) {
        for (const type of ["string", "number", "boolean"]) {
            const value = this.configMaps[type].get(domain)?.get(name);
            if (value !== undefined) {
                if (default_value || value[1] == undefined) {
                    return value[0];
                }
                return value[1];
            }
            ;
        }
        return undefined;
    }
    /** @inheritdoc */
    hasConfig(domain, name) {
        return this.isString(domain, name) || this.isNumber(domain, name) || this.isBool(domain, name);
    }
    /** @inheritdoc */
    isString(domain, name) {
        const found = this.configMaps.string.get(domain);
        if (found && found.has(name)) {
            return true;
        }
        return false;
    }
    /** @inheritdoc */
    isNumber(domain, name) {
        const found = this.configMaps.number.get(domain);
        if (found && found.has(name)) {
            return true;
        }
        return false;
    }
    /** @inheritdoc */
    isBool(domain, name) {
        const found = this.configMaps.boolean.get(domain);
        if (found && found.has(name)) {
            return true;
        }
        return false;
    }
}
exports.default = ConfigurationService;
//# sourceMappingURL=configuration_service.js.map