"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WinstonLogger = void 0;
const winston_1 = require("winston");
const path_1 = __importDefault(require("path"));
const { timestamp, printf } = winston_1.format;
const myFormat = printf(({ level, message, service, timestamp }) => {
    return `${timestamp} [${service}] ${level}: ${message}`;
});
const jobsOnlyFilter = (0, winston_1.format)((info) => {
    return info.service === 'Jobs' ? info : false;
});
/** @inheritdoc */
class LoggingRegistry {
    /** @inheritdoc */
    constructor(data_directory) {
        this.data_directory = data_directory;
        this.logger = (0, winston_1.createLogger)({
            level: 'debug',
            format: winston_1.format.json(),
            transports: [
                new winston_1.transports.Console({
                    format: winston_1.format.combine(winston_1.format.colorize(), timestamp(), winston_1.format.errors({ stack: true }), myFormat)
                }),
                new winston_1.transports.File({
                    filename: path_1.default.join(this.data_directory, 'job.log'),
                    format: winston_1.format.combine(jobsOnlyFilter(), winston_1.format.json()),
                }),
                new winston_1.transports.File({ filename: path_1.default.join(this.data_directory, 'job.log') })
            ],
        });
    }
    /** @inheritdoc */
    registerLogger(service) {
        return new WinstonLogger(this.logger.child({ service: service }));
    }
}
exports.default = LoggingRegistry;
/**
 * Wraps a Winston logger in an adpator interface.
 */
class WinstonLogger {
    /**
     * Creates a new LoggerWrapper, using the Winston logger passed in.
     */
    constructor(logger) {
        this.logger = logger;
    }
    /** @inheritdoc */
    info(message, ...meta) {
        this.logger.info(message, ...meta);
    }
    /** @inheritdoc */
    warn(message, ...meta) {
        this.logger.warn(message, ...meta);
    }
    /** @inheritdoc */
    error(message, ...meta) {
        this.logger.error(message, ...meta);
    }
    /** @inheritdoc */
    debug(message, ...meta) {
        this.logger.debug(message, ...meta);
    }
}
exports.WinstonLogger = WinstonLogger;
//# sourceMappingURL=logging_service.js.map