"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
const path = __importStar(require("path"));
const schemas_1 = require("../schemas/schemas");
/** @inheritdoc */
class SettingsService {
    /**
     * Constructs the settings service which stores app settings.
     */
    constructor(data_directory) {
        this.data_directory = data_directory;
        this.cached_settings = undefined;
    }
    /** @inheritdoc */
    getDefaultSettings() {
        return (0, schemas_1.AppSettingsSchemaFactory)(path.join(this.data_directory, 'Plugins'), path.join(this.data_directory, 'Captures')).parse({});
    }
    /** @inheritdoc */
    async getPluginsDirectory() {
        return (await (this.getSettings())).plugins_directory;
    }
    /** @inheritdoc */
    async getCapturesDirectory() {
        return (await (this.getSettings())).captures_directory;
    }
    async reloadSettings() {
        this.cached_settings = undefined;
        await this.getSettings();
    }
    /** @inheritdoc */
    async getSettings() {
        // Return cached settings if already loaded
        if (this.cached_settings)
            return this.cached_settings;
        if (!this.filesystem) {
            const defaults = this.getDefaultSettings();
            this.cached_settings = defaults;
            return defaults;
        }
        return this.filesystem.getSettingsFile();
    }
    /** @inheritdoc */
    async saveSettings() {
        if (!this.filesystem) {
            throw new Error("Could not save as filesystem has not been registered. Did you forget to call registerFilesystem(filesystem) on this settings service?");
        }
        if (!this.cached_settings) {
            throw new Error("No settings yet loaded. Did not save.");
        }
        await this.filesystem?.writeSettingsFile(this.cached_settings);
    }
    /** @inheritdoc */
    setSettings(settings) {
        this.cached_settings = settings;
    }
    /** @inheritdoc */
    registerFilesystem(filesystem) {
        this.filesystem = filesystem;
    }
}
exports.default = SettingsService;
//# sourceMappingURL=settings_service.js.map