"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const filesystem_service_1 = __importDefault(require("./services/filesystem_service"));
const sfvc_1 = __importDefault(require("./program/sfvc"));
const configuration_service_1 = __importDefault(require("./services/configuration_service"));
const formatting_service_1 = __importDefault(require("./services/formatting_service"));
const settings_service_1 = __importDefault(require("./services/settings_service"));
const job_queue_1 = require("./services/job_queue");
const logging_service_1 = __importDefault(require("./services/logging_service"));
const puppeteer_service_1 = __importDefault(require("./services/puppeteer_service"));
const path_1 = __importDefault(require("path"));
const os_1 = require("os");
//This is where internal stuff like logs, settings etc are stored.
const data_directory = path_1.default.join((0, os_1.homedir)(), 'Documents', 'sfvc');
const settings = new settings_service_1.default(data_directory);
const formatter = new formatting_service_1.default(settings);
const logRegistry = new logging_service_1.default(data_directory);
const filesystem = new filesystem_service_1.default(formatter, settings, logRegistry.registerLogger("FileSystemService"), data_directory);
const jobQueue = new job_queue_1.JobQueue(new Set(), logRegistry.registerLogger("JobQueue"), filesystem);
const config = new configuration_service_1.default();
const puppeteer = new puppeteer_service_1.default(logRegistry.registerLogger("PuppeteerService"));
//TODO: currently being passed in twice in-case there's a need later on to separate the job logger from the SFV logger.
const job_logger = logRegistry.registerLogger("Jobs");
const sfvc_app = new sfvc_1.default(config, jobQueue, filesystem, job_logger, puppeteer, job_logger);
jobQueue.addListener(sfvc_app);
// Electron setup
const electron_1 = require("electron");
const api_service_1 = __importDefault(require("./services/api/api_service"));
const routes_1 = require("./services/api/routes/routes");
if (Object.prototype.hasOwnProperty.call(process.versions, 'electron')) {
    electron_1.app.whenReady().then(() => {
        const resources_path = electron_1.app.isPackaged ? process.resourcesPath : process.cwd();
        //API setup
        bootstrapAPI(resources_path);
        const win = new electron_1.BrowserWindow({
            width: 800,
            height: 600,
            icon: path_1.default.join(resources_path, 'dist', 'frontend', 'favicon.icon')
        });
        win.loadURL('http://localhost:3000');
    });
}
//App is running in a Node.js environment sans-electron
bootstrapAPI(process.cwd());
function bootstrapAPI(resources_path) {
    const api_logger = logRegistry.registerLogger("API");
    const index = path_1.default.join(resources_path, 'dist', 'frontend', 'index.html');
    const router = (0, routes_1.createRoutesExpress)(filesystem, jobQueue, settings, config, index, api_logger, formatter);
    (0, api_service_1.default)(router, api_logger, resources_path);
}
