"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppSettingsSchema = exports.PluginManifestSchema = exports.AppProcessStatusSchema = exports.GatheredTraitSchema = exports.EventSchema = exports.TraitsSchema = exports.ManifestSchema = exports.JobRequestSchema = exports.CaptureSchema = exports.PatchCaptureActionSchema = exports.StringArraySchema = exports.PathSchema = exports.StringDict = void 0;
const z = __importStar(require("zod/v4"));
// Utility type for Dictionary<string, string>
exports.StringDict = z.record(z.string(), z.string());
exports.PathSchema = z.string();
exports.StringArraySchema = z.array(z.string());
exports.PatchCaptureActionSchema = z.object({
    name: z.string(),
});
exports.CaptureSchema = z.object({
    events: z.array(z.string()),
});
exports.JobRequestSchema = z.object({
    operator: z.string(),
    controllers: z.array(z.string()),
    events: z.number().int().min(1).max(999),
    settings: exports.StringDict,
    name: z.string(),
    id: z.uuidv7()
});
exports.ManifestSchema = z.object({
    video_id: z.string(),
    gathered_at: z.coerce.date(),
    gathered_by: z.string(),
    client_data: z.string(),
});
exports.TraitsSchema = z.object({
    requested_by: z.array(z.string()),
    traits: z.array(z.string()).transform(arr => new Set(arr)),
});
exports.EventSchema = z.object({
    manifest: exports.ManifestSchema,
    traits: z.array(exports.TraitsSchema),
});
exports.GatheredTraitSchema = z.object({
    raw: z.string(),
    scraped: exports.StringDict,
});
exports.AppProcessStatusSchema = z.object({
    events_gathered: z.number(),
    currently_gathering: z.string(),
    current_event: z.string(),
    current_capture: z.string(),
});
exports.PluginManifestSchema = z.object({
    name: z.string(),
    author: z.string(),
    description: z.string(),
    version: z.string(),
    type: z.enum(["controller", "operator", "collector", "extension"]),
    traits: z.array(z.string()).optional().or(z.literal(''))
});
exports.AppSettingsSchema = z.object({
    captures_directory: exports.PathSchema,
    plugins_directory: exports.PathSchema,
    event_format: z.string(),
    capture_format: z.string()
});
