"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = setupAPI;
const express_1 = __importDefault(require("express"));
const path_1 = __importDefault(require("path"));
const cors_1 = __importDefault(require("cors"));
const body_parser_1 = __importDefault(require("body-parser"));
function setupAPI(router, logger, resources_path) {
    const app = (0, express_1.default)();
    app.use(body_parser_1.default.json());
    //TODO: this should be configurable from the UI
    const corsOptions = {
        origin: ["http://localhost:5173"]
    };
    app.use((0, cors_1.default)(corsOptions));
    app.use(router);
    app.use(express_1.default.static(path_1.default.join(resources_path, 'dist', 'frontend')));
    // Start the server
    const PORT = process.env.PORT || 3000;
    app.listen(PORT, () => {
        logger.info(`Server started at http://localhost:${PORT}/`);
    });
}
