"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createRoutesExpress = createRoutesExpress;
const express_1 = __importDefault(require("express"));
const route_handlers_1 = require("../controllers/route_handlers");
function createRoutesExpress(filesystem, jobQueue, settings, config, index_path, logger, formatter) {
    const router = express_1.default.Router();
    // Serve index
    router.get('/', (req, res) => (0, route_handlers_1.serveIndex)(req, res, index_path));
    // Capture routes
    router.get('/captures', (req, res) => (0, route_handlers_1.getCapturesList)(req, res, filesystem, logger));
    router.patch('/captures/:captureId', (req, res) => (0, route_handlers_1.patchCapture)(req, res, filesystem, logger));
    router.get('/captures/:captureId', (req, res) => (0, route_handlers_1.getCaptureById)(req, res, filesystem, logger));
    router.get('/captures/:captureId/:eventId', (req, res) => (0, route_handlers_1.getEventById)(req, res, filesystem, logger));
    router.get('/captures/:captureId/:eventId/:traitId', (req, res) => (0, route_handlers_1.getTraitById)(req, res, filesystem, logger));
    // App states
    router.post('/app/jobs', (req, res) => (0, route_handlers_1.addJob)(req, res, formatter, settings, jobQueue, logger));
    router.get('/app/jobs', (req, res) => (0, route_handlers_1.getJobs)(req, res, jobQueue, logger));
    router.get('/app/jobs/status', (req, res) => (0, route_handlers_1.getJobsStatus)(req, res, filesystem, logger));
    // App plugins routes
    router.get('/app/plugins', (req, res) => (0, route_handlers_1.listPlugins)(req, res, filesystem, logger));
    router.get('/app/plugins/:name', (req, res) => (0, route_handlers_1.getPluginManifest)(req, res, filesystem, logger));
    // App settings routes
    router.post('/app/settings', (req, res) => (0, route_handlers_1.setSettings)(req, res, settings, logger));
    router.get('/app/settings', (req, res) => (0, route_handlers_1.getSettings)(req, res, settings, logger));
    return router;
}
