"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class FormattingService {
    constructor(settings) {
        this.settings = settings;
    }
    async format_capture(value, format, job_id) {
        const human_date = (date) => `${date.getFullYear()}${date.getMonth() + 1 < 10 ? '0' + date.getMonth() + 1 : date.getMonth() + 1}${date.getDate() < 10 ? '0' + date.getDate() : date.getDate()}`;
        const human_time = (date) => `${date.getHours() < 10 ? '0' + date.getHours() : date.getHours()}${date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes()}`;
        return format.replace('{date}', human_date(new Date()).replace('{time}', human_time(new Date())).replace('{id}', job_id ? job_id.substring(24, 36) : ''));
    }
}
exports.default = FormattingService;
