"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoggerWrapper = void 0;
const winston_1 = require("winston");
const path_1 = __importDefault(require("path"));
const { timestamp, printf } = winston_1.format;
const myFormat = printf(({ level, message, service, timestamp }) => {
    return `${timestamp} [${service}] ${level}: ${message}`;
});
const jobsOnlyFilter = (0, winston_1.format)((info) => {
    return info.service === 'Jobs' ? info : false;
});
class LoggingRegistry {
    constructor(data_directory) {
        this.data_directory = data_directory;
        this.logger = (0, winston_1.createLogger)({
            level: 'debug',
            format: winston_1.format.json(),
            transports: [
                new winston_1.transports.Console({
                    format: winston_1.format.combine(winston_1.format.colorize(), timestamp(), winston_1.format.errors({ stack: true }), myFormat)
                }),
                new winston_1.transports.File({
                    filename: path_1.default.join(this.data_directory, 'job.log'),
                    format: winston_1.format.combine(jobsOnlyFilter(), winston_1.format.json()),
                }),
                new winston_1.transports.File({ filename: path_1.default.join(this.data_directory, 'job.log') })
            ],
        });
    }
    registerLogger(service) {
        return new LoggerWrapper(this.logger.child({ service: service }));
    }
}
exports.default = LoggingRegistry;
class LoggerWrapper {
    constructor(logger) {
        this.logger = logger;
    }
    info(message, ...meta) {
        this.logger.info(message, ...meta);
    }
    warn(message, ...meta) {
        this.logger.warn(message, ...meta);
    }
    error(message, ...meta) {
        this.logger.error(message, ...meta);
    }
    debug(message, ...meta) {
        this.logger.debug(message, ...meta);
    }
}
exports.LoggerWrapper = LoggerWrapper;
