"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class FormattingService {
    format_string(format, id, date) {
        const internal_date = date ?? new Date();
        const human_date = (date) => `${date.getFullYear()}${date.getMonth() + 1 < 10 ? '0' + date.getMonth() + 1 : date.getMonth() + 1}${date.getDate() < 10 ? '0' + date.getDate() : date.getDate()}`;
        const human_time = (date) => `${date.getHours() < 10 ? '0' + date.getHours() : date.getHours()}${date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes()}`;
        return format.replace('{date}', human_date(internal_date)).replace('{id}', id ? id.substring(24, 36) : 'unknown').replace('{time}', human_time(internal_date));
    }
}
exports.default = FormattingService;
//# sourceMappingURL=formatting_service.js.map