"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shortWait = shortWait;
exports.format_string = format_string;
/**
 * Shorthand for waiting between 1 and 2 seconds, randomly.
 */
function shortWait() {
    return new Promise(r => setTimeout(r, 1000 + (Math.random() * 1000)));
}
/**
* Applies known formatting rules to passed format string.
* @param format The format string
* @param job_id The job that this format corresponds to, if provided.
* @param date The date to use in formatting, if provided.
*/
function format_string(format, id, date) {
    const internal_date = date ?? new Date();
    const human_date = (date) => `${date.getFullYear()}${date.getMonth() + 1 < 10 ? '0' + date.getMonth() + 1 : date.getMonth() + 1}${date.getDate() < 10 ? '0' + date.getDate() : date.getDate()}`;
    const human_time = (date) => `${date.getHours() < 10 ? '0' + date.getHours() : date.getHours()}${date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes()}`;
    return format.replace('{date}', human_date(internal_date)).replace('{id}', id ? id.substring(24, 36) : 'unknown').replace('{time}', human_time(internal_date));
}
//# sourceMappingURL=utils.js.map