import { Validator, Controller, ControllerContext } from "#sfvc_types/plugin";

//Manifest:
//Name: BasicController

export async function activate(context: ControllerContext): Promise<Controller> {
    const stringValidator: Validator<string> = {
        hint: "Traits to be collected, separated by comma",
        //TODO rewrite this so it actually validates traits!
        validate: function (value: string): boolean {
            if (value.includes(";"))
                return false;
            if (value.includes(" "))
                return false;
            if (value.length === 0)
                return false
            return true;
        }
    }
    context.configurationServer.addConfig("basic_controller", "traits", "id,url", stringValidator)
    return {
        getTraits: () => {
            if (!context.configurationServer.hasConfig("basic_controller", "traits")) {
                return [];
            }
            return context.configurationServer.getConfig("basic_controller", "traits")!.split(",")
        }
    }
}
