"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.activate = activate;
/**
 * Set up the TikTok Operator
 * @param page Reference to the page used for this Operator
 */
async function activate(context, page) {
    const logger = context.logger;
    logger.debug("activated tiktok operator");
    const page_url = 'https://www.tiktok.com';
    await page.browser().deleteCookie();
    await page.setCacheEnabled(false);
    await page.setViewport({ width: 1080, height: 1024 });
    await page.goto(page_url);
    await page.waitForSelector("aria/For You", { timeout: 5000 });
    await page.locator("aria/For You").click();
    await page.waitForSelector('.tiktok-web-player', { timeout: 5000 });
    await page.evaluate(randomPromise);
    await page.locator("main").click(); //click on the main element to activate keyboard shortcuts
    // TODO check for the popup window in the login
    //Now that the page is ready, we don't need to do anything else.
    return {
        scroll: async () => {
            await page.keyboard.press('ArrowDown');
            // Optional: wait a bit for content to load after scrolling
            await page.evaluate(randomPromise);
        },
        operations: {
            "id": {
                run: async (ResultMap) => {
                    await page.waitForSelector("button[aria-label^='Read or add']", { timeout: 1000 });
                    let commentBtns = await page.$$("button[aria-label^='Read or add']");
                    let currentCommentBtn = commentBtns[0];
                    commentBtns.forEach(async (btn) => {
                        if (await btn.isIntersectingViewport())
                            currentCommentBtn = btn;
                    });
                    currentCommentBtn.click(); // open the comment box
                    const id = new URL(page.url()).pathname;
                    ResultMap.set("id", { raw: "", processed: id });
                    logger.debug(`id: ${id}`);
                    currentCommentBtn.click(); // close the comment box
                }
            },
            "comments": {
                run: async (ResultMap) => {
                    logger.warn(`trait not implemented`);
                }
            },
            "url": {
                run: async (ResultMap) => {
                    logger.warn(`trait not implemented`);
                }
            },
            "creator": {
                run: async (ResultMap) => {
                    logger.warn(`trait not implemented`);
                }
            },
            "created_at": {
                run: async (ResultMap) => {
                    logger.warn(`trait not implemented`);
                }
            },
            "thumbnail_url": {
                run: async (ResultMap) => {
                    logger.warn(`trait not implemented`);
                }
            },
            "title": {
                run: async (ResultMap) => {
                    logger.warn(`trait not implemented`);
                }
            },
            "description": {
                run: async (ResultMap) => {
                    logger.warn(`trait not implemented`);
                }
            },
            "comments_count": {
                run: async (ResultMap) => {
                    logger.warn(`trait not implemented`);
                }
            },
            "likes_count": {
                run: async (ResultMap) => {
                    logger.warn(`trait not implemented`);
                }
            },
            "views_count": {
                run: async (ResultMap) => {
                    logger.warn(`trait not implemented`);
                }
            }
        }
    };
}
function randomPromise() {
    return () => new Promise(r => setTimeout(r, 1000 + (Math.random() * 1000)));
}
