"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.activate = activate;
async function activate(context) {
    const stringValidator = {
        hint: "Traits to be collected, separated by comma",
        //TODO rewrite this so it actually validates traits!
        validate: function (value) {
            if (value.includes(";"))
                return false;
            if (value.includes(" "))
                return false;
            if (value.length === 0)
                return false;
            return true;
        }
    };
    context.configurationServer.addConfig("basic_controller", "traits", "id,url,creator,created_at,description,likes_count,views_count,comments_count,comments", stringValidator);
    return {
        getTraits: () => {
            if (!context.configurationServer.hasConfig("basic_controller", "traits")) {
                return [];
            }
            return context.configurationServer.getConfig("basic_controller", "traits").split(",");
        }
    };
}
